' ----------------------------------------------------------------------------
' Type field to retrieve
' ----------------------------------------------------------------------------
Type TConfig

	Global config:TMap = CreateMap()
	
	' load config file
	Method Load(s:TStream)
		
		While Not Eof(s)
		
			' read next line
			Local l:String = ReadLine(s)
									
			' check if line contains a "=" char
			Local d:Int = Instr(l, "=")
			
			' get left value (key)
			Local k:String = Lower(Left(l, d - 1))
			
			' get right right value (value)
			Local v:String = Mid(l, d + 1, Len(l))
									
			' insert key/value couple to TMap
			MapInsert(config, k, v)
			
		Wend
			
	End Method
	
	' retrieve config object from TMap
	Function Get:String(Key:String)
		
		Return String(MapValueForKey(config, Lower(Key)))
	
	End Function

End Type